/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.cogsys.app2igor.core;

import de.uniba.cogsys.app2igor.args.MaudeArgs;
import de.uniba.cogsys.app2igor.core.InteropCenter;
import de.uniba.cogsys.app2igor.core.Runner;
import de.uniba.cogsys.app2igor.iface.App2IgorInterop;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class App2IgorInteropImpl
implements App2IgorInterop {
    private Runner igor;
    private InteropCenter center;

    public App2IgorInteropImpl(InteropCenter center) {
        this.center = center;
    }

    @Override
    public void abortIgor() {
        this.igor.interrupt();
    }

    @Override
    public List<String> getModuleNames() {
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(String.valueOf(this.center.getFile()) + ".maude");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                if (!strLine.trim().startsWith("fmod")) continue;
                strLine = strLine.replaceAll("fmod", "");
                strLine = strLine.replaceAll("is", "");
                strLine = strLine.trim();
                retVal.add(strLine);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return retVal;
    }

    @Override
    public Runner startIgor(List<String> modules, boolean createOutFile) throws IOException {
        Runner r = new Runner(this.center.getIgorHome(), this.center.getMaudeHome(), this.center.getFile(), this.center.getFileStream(), modules, new ArrayList<MaudeArgs>(), this.center.getIgorVersion(), createOutFile);
        r.start();
        this.igor = r;
        return r;
    }

    @Override
    public Runner startIgor(List<String> modules, List<MaudeArgs> args, boolean createOutFile) throws IOException {
        Runner r = new Runner(this.center.getIgorHome(), this.center.getMaudeHome(), this.center.getFile(), this.center.getFileStream(), modules, args, this.center.getIgorVersion(), createOutFile);
        r.start();
        this.igor = r;
        return r;
    }

    @Override
    public HashMap<String, String> getModules() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(String.valueOf(this.center.getFile()) + ".maude");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String tmpModName = "";
            String tmpModCode = "";
            while ((strLine = br.readLine()) != null) {
                if (strLine.trim().startsWith("fmod")) {
                    tmpModCode = strLine;
                    strLine = strLine.replaceAll("fmod", "");
                    strLine = strLine.replaceAll("is", "");
                    tmpModName = strLine = strLine.trim();
                    strLine = "";
                }
                tmpModCode = String.valueOf(tmpModCode) + strLine + "\n";
                if (!strLine.trim().startsWith("endfm")) continue;
                retVal.put(tmpModName, tmpModCode);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        return retVal;
    }
}

