/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.cogsys.app2igor.core;

import de.uniba.cogsys.app2igor.args.MaudeArgTranslator;
import de.uniba.cogsys.app2igor.args.MaudeArgs;
import de.uniba.cogsys.app2igor.datatype.IgorResult;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Runner
extends Thread {
    private String igorHome;
    private String maudeHome;
    private String fileName;
    private String fileStream;
    private String functionName;
    private Process proc;
    private List<String> modules = new ArrayList<String>();
    private List<MaudeArgs> args = new ArrayList<MaudeArgs>();
    private boolean createOutFile = false;
    private boolean finished = false;
    private boolean interrupted = false;
    private IgorResult result;
    private String igorVersion;

    public Runner(String igorHome, String maudeHome, String fileName, String fileStream, List<String> modules, List<MaudeArgs> args, String igorVersion, boolean createOutFile) {
        this.igorHome = igorHome;
        this.maudeHome = maudeHome;
        this.fileName = fileName;
        this.fileStream = fileStream;
        this.modules = modules;
        this.args = args;
        this.createOutFile = createOutFile;
        this.igorVersion = igorVersion;
    }

    public String[] startIgor() {
        Vector<String> result = new Vector<String>();
        String[] command = new String[this.args.size() + 1];
        command[0] = String.valueOf(this.maudeHome) + "maude.linux";
        if (this.args.size() > 0) {
            int i = 1;
            MaudeArgTranslator translator = new MaudeArgTranslator();
            for (MaudeArgs arg : this.args) {
                command[i] = translator.translateArg(arg);
                ++i;
            }
        }
        Runtime rt = Runtime.getRuntime();
        try {
            CommandExecutor executor;
            this.proc = rt.exec(command);
            InputStream err = this.proc.getErrorStream();
            BufferedReader maudeErr = new BufferedReader(new InputStreamReader(err));
            InputStream in = this.proc.getInputStream();
            BufferedReader maudeOut = new BufferedReader(new InputStreamReader(in));
            if (!this.fileName.equals("")) {
                executor = new CommandExecutor(this.proc.getOutputStream(), String.valueOf(this.fileName) + ".maude", "", this.functionName);
                executor.start();
            } else {
                executor = new CommandExecutor(this.proc.getOutputStream(), "", this.fileStream, this.functionName);
                executor.start();
            }
            int exitVal = this.proc.waitFor();
            if (this.interrupted) {
                return new String[0];
            }
            BufferedReader out = exitVal != 0 ? maudeErr : maudeOut;
            String text = "";
            while ((text = out.readLine()) != null) {
                text.trim();
                result.add(text);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String[] retVal = result.toArray(new String[0]);
        if (this.createOutFile) {
            File output = new File(String.valueOf(this.fileName) + ".out");
            try {
                output.createNewFile();
                BufferedWriter out = new BufferedWriter(new FileWriter(output));
                String[] stringArray = retVal;
                int n = retVal.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    out.write(String.valueOf(string) + "\n");
                    ++n2;
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    @Override
    public void run() {
        this.finished = false;
        this.result = new IgorResult(this.startIgor());
        this.finished = true;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        this.proc.destroy();
    }

    public IgorResult getIgorResult() {
        return this.result;
    }

    private class CommandExecutor
    extends Thread {
        OutputStream os;
        String file = "";
        String funName = "";
        String fileStream = "";

        public CommandExecutor(OutputStream os, String file, String fileStream, String funName) {
            this.os = os;
            this.file = file;
            this.fileStream = fileStream;
            this.funName = funName;
        }

        @Override
        public void run() {
            BufferedOutputStream bufferout = new BufferedOutputStream(this.os);
            PrintWriter commandInput = new PrintWriter((Writer)new OutputStreamWriter(bufferout), true);
            for (String string : Runner.this.modules) {
                commandInput.println("load " + string);
            }
            if (!this.file.equals("")) {
                commandInput.println("load " + this.file);
            } else {
                commandInput.println(this.fileStream);
            }
            if (Runner.this.igorVersion.equals("2.2")) {
                commandInput.println("load " + Runner.this.igorHome + "igor2.2.maude");
                commandInput.println("reduce in IGOR : setup('" + (String)Runner.this.modules.get(Runner.this.modules.size() - 1) + ", 1, false).");
                System.out.println("reduce in IGOR : setup('" + (String)Runner.this.modules.get(Runner.this.modules.size() - 1) + ", 1, false).");
            }
            if (Runner.this.igorVersion.equals("2.3")) {
                commandInput.println("load " + Runner.this.igorHome + "igor2.3.maude");
                commandInput.println("reduce in IGOR : generalize('" + (String)Runner.this.modules.get(Runner.this.modules.size() - 1) + ").");
            }
            commandInput.println("quit");
            commandInput.close();
        }
    }
}

