package de.yanenko.igor;

import javax.swing.JComponent;
import javax.swing.JFrame;

/**
 * <p>Class Hypotheses, which contains the main class of the project. If an IGOR log file
 * is passed over as argument, the parser creates a TreeML file. If the argument is already
 * a TreeML file, only the visualization is started.</p>
 * <p>For more information about the IGOR-Software please visit <a href="http://www.cogsys.wiai.uni-bamberg.de/effalip/">www.cogsys.wiai.uni-bamberg.de/effalip/</a>.
 * </p>
 * 
 * @version 1.0
 * @author <a href="http://www.yanenko.de">Olga Yanenko</a>
 */
public class Hypotheses {
	
	/** The input file. */
	private static String INPUT;
	
	/** The output file. */
	private static String OUTPUT;

    /**
     * The main method.
     * 
     * @param args the log file
     */
    public static void main(String args[]) {
    	INPUT = args[0];
    	// Display help.
    	if (INPUT.equals("-h")) {
    		System.out.println("Usage:");
    		System.out.println("		istviewer.jar [log file path]");
    		System.out.println("		(parses the logfile,");
    		System.out.println("		(creates a TreeML file in the same directory");
    		System.out.println("		(and shows the visualization)");
    		System.out.println("or");
    		System.out.println("		istviewer.jar [TreeML file path]");
    		System.out.println("		(only starts the visualization)");
    		System.out.println("");
    		System.out.println("Help and manual:");
    		System.out.println("		istviewer.jar -h");
    		System.out.println("		(shows help)");
    		System.out.println("		istviewer.jar -m");
    		System.out.println("		(shows user manual)");
    	} else if (INPUT.equals("-m")) {
    		System.out.println("User Manual");
    		System.out.println("");
    		System.out.println("The spinners in the top left and top right corners are used to select the orientation and weight to display.");
    		System.out.println("");
    		System.out.println("The search field in top center is used for searching nodes with a specific number.");
    		System.out.println("");
    		System.out.println("A single left click on a node shows the according hypotheses in the node info field and expands the children of the node.");
    		System.out.println("");
    		System.out.println("A double left click on a node expands the complete subtree of the node.");
    		System.out.println("");
    		System.out.println("A single right click on a node collapses all children of the node.");
    		System.out.println("");
    		System.out.println("Hovering over nodes shows a tool tip containing the node weight. Hovering over edges shows a tool tip containing the operator.");
    		System.out.println("");
    		System.out.println("The tree can be dragged and dropped inside the frame by clicking and holding the left mouse button beside the tree view.");
    		System.out.println("");
    		System.out.println("The tree can be zoomed by rolling the wheel button.");
    	} else {
    		// Parse the document, if the input file is not a TreeML file.
	    	if (!INPUT.substring(INPUT.length()-3, INPUT.length()).equals("tml")) {
	    		// Name for the output file.
	    		OUTPUT = INPUT.substring(0, INPUT.length()-3) + "tml";
	    		System.out.println("Parsing the logfile. Please wait...");
	        	Parser parser = new Parser(INPUT, OUTPUT);
	    		parser.run();
	    	} else {
	    		OUTPUT = INPUT;
	    	}
	    	System.out.println("Loading the visualization. Please wait...");
			// Swing component which contains the tree view. 
			JComponent treeview = HypoTree.show(OUTPUT);
			// Swing frame.
	        JFrame frame = new JFrame("Vizualization of Hypotheses produced by IGOR2+");
	        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	        frame.setContentPane(treeview);
	        frame.pack();
	        frame.setVisible(true);
    	}
    }
}